/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.code.signing.tool.commands;

import com.ssl.code.signing.tool.csc.CscApi;
import com.ssl.code.signing.tool.exception.CscApiException;
import com.ssl.code.signing.tool.util.AccessToken;
import com.ssl.code.signing.tool.util.Paths;
import de.taimos.totp.TOTP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import picocli.CommandLine;

@CommandLine.Command(name="sign_hash", description={"Sign the hash(es)"}, version={"v1.2.7"}, mixinStandardHelpOptions=true)
public class SignHashCommand
implements Runnable {
    private static final Logger logger;
    @CommandLine.Option(names={"-username"}, description={"RA username"}, required=true)
    private String username;
    @CommandLine.Option(names={"-password"}, description={"RA password"}, required=true)
    private String password;
    @CommandLine.Option(names={"-credential_id"}, description={"Credential ID"}, required=false)
    private String credentialId;
    @CommandLine.Option(names={"-hash"}, description={"Comma separated base64 encoded hash(es) to sign"}, required=true)
    private String hash;
    @CommandLine.Option(names={"-totp_secret"}, description={"TOTP secret"}, required=false)
    private String totpSecret;
    @CommandLine.Option(names={"-output_dir_path"}, description={"Directory where comma separated signature values will be written"}, required=true)
    private String outputDirPath;

    @Override
    public void run() {
        try {
            logger.info("Command: sign hash");
            Properties props = new Properties();
            props.load(new FileInputStream(Paths.getConfigFilePath()));
            String clientId = props.getProperty("CLIENT_ID");
            logger.info("Client ID: " + clientId);
            String oauth2Endpoint = props.getProperty("OAUTH2_ENDPOINT");
            logger.info("OAuth2 URL: " + oauth2Endpoint);
            String cscEndpoint = props.getProperty("CSC_API_ENDPOINT");
            logger.info("CSC Endpoint: " + cscEndpoint);
            File outputDir = new File(this.outputDirPath);
            if (!outputDir.isDirectory()) {
                logger.info("Not a valid output directory: " + this.outputDirPath);
                System.out.print("Error: Not a valid output directory - " + this.outputDirPath);
                return;
            }
            logger.info("Output directory path: " + outputDir);
            AccessToken accessTokenObj = new AccessToken(clientId, this.username, this.password, oauth2Endpoint);
            String accessToken = accessTokenObj.getAccessToken();
            logger.info("Credential ID retrieved from signatures service: " + this.credentialId);
            CscApi cscApi = new CscApi(accessToken, cscEndpoint);
            String otp = null;
            if (this.totpSecret == null || this.totpSecret.equals("")) {
                System.out.print("Enter the OTP - Press enter to continue: ");
                Scanner otpInput = new Scanner(System.in);
                otp = otpInput.nextLine();
                if (otp == null || otp.equals("")) {
                    System.out.print("Error: OTP not provided");
                    return;
                }
            } else {
                byte[] totpSeed = Base64.getDecoder().decode(this.totpSecret);
                String hexKey = Hex.encodeHexString((byte[])totpSeed);
                otp = TOTP.getOTP((String)hexKey);
            }
            String[] hashes = this.hash.split(",");
            String sad = cscApi.getCredentialsAuthorize(this.credentialId, hashes.length, hashes, otp);
            String[] signatures = cscApi.signHash(this.credentialId, sad, hashes, "1.2.840.113549.1.1.11", false);
            StringBuilder sigs = new StringBuilder();
            for (int i = 0; i < signatures.length; ++i) {
                sigs.append(signatures[i]);
                if (i == signatures.length - 1) continue;
                sigs.append(",");
            }
            FileOutputStream out = new FileOutputStream(this.outputDirPath + File.separator + "signatures.sig");
            out.write(sigs.toString().getBytes());
            out.close();
            System.out.println("Sign hash(es) command executed successfully. Signatures file is created at: " + this.outputDirPath + File.separator + "signatures.sig");
        }
        catch (CscApiException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("", (Throwable)ex);
        }
    }

    static {
        try {
            FileInputStream inputStream = new FileInputStream(Paths.getLog4j2Path());
            ConfigurationSource source = new ConfigurationSource((InputStream)inputStream);
            Configurator.initialize(null, (ConfigurationSource)source);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger = LogManager.getLogger(SignHashCommand.class);
    }
}

