/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.code.signing.tool.commands;

import com.ssl.code.signing.tool.code.CatSignature;
import com.ssl.code.signing.tool.code.CodeSignature;
import com.ssl.code.signing.tool.code.JarSignature;
import com.ssl.code.signing.tool.code.OvaSignature;
import com.ssl.code.signing.tool.csc.CscApi;
import com.ssl.code.signing.tool.exception.AccessTokenException;
import com.ssl.code.signing.tool.exception.CscApiException;
import com.ssl.code.signing.tool.mscab.MSCabinetFile;
import com.ssl.code.signing.tool.util.AccessToken;
import com.ssl.code.signing.tool.util.Paths;
import de.taimos.totp.TOTP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.stream.Stream;
import net.jsign.DigestAlgorithm;
import net.jsign.msi.MSIFile;
import net.jsign.pe.PEFile;
import net.jsign.script.JScript;
import net.jsign.script.PowerShellScript;
import net.jsign.script.PowerShellXMLScript;
import net.jsign.script.VBScript;
import net.jsign.script.WindowsScript;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.bouncycastle.asn1.ASN1Object;
import picocli.CommandLine;

@CommandLine.Command(name="sign", description={"Sign code"}, version={"v1.2.7"}, mixinStandardHelpOptions=true)
public class SignCommand
implements Runnable {
    private static final Logger logger;
    @CommandLine.Option(names={"-username"}, description={"RA username"}, required=true)
    private String username;
    @CommandLine.Option(names={"-password"}, description={"RA password"}, required=true)
    private String password;
    @CommandLine.Option(names={"-credential_id"}, description={"Credential ID"}, required=false)
    private String credentialId;
    @CommandLine.Option(names={"-input_file_path"}, description={"Path of the code object to be signed"}, required=true)
    private String inputFilePath;
    @CommandLine.Option(names={"-output_dir_path"}, description={"Directory where signed code object will be written"}, required=false)
    private String outputDirPath;
    @CommandLine.Option(names={"-totp_secret"}, description={"TOTP secret"}, required=false)
    private String totpSecret;
    @CommandLine.Option(names={"-program_name"}, description={"Program name"}, required=false)
    private String programName;
    @CommandLine.Option(names={"-override"}, description={"Overrides the input file after signing, if this parameter is set and no -output_dir_path parameter"}, required=false)
    private boolean override;
    @CommandLine.Option(names={"-malware_block"}, description={"Overrides the malware scan settings configured on server"}, required=false)
    private boolean malwareBlock;

    @Override
    public void run() {
        try {
            File file;
            String signature;
            List<X509Certificate> certs;
            logger.info("Command: sign");
            Properties props = new Properties();
            props.load(new FileInputStream(Paths.getConfigFilePath()));
            String clientId = props.getProperty("CLIENT_ID");
            logger.info("Client ID: " + clientId);
            String oauth2Endpoint = props.getProperty("OAUTH2_ENDPOINT");
            logger.info("OAuth2 URL: " + oauth2Endpoint);
            String cscEndpoint = props.getProperty("CSC_API_ENDPOINT");
            logger.info("CSC Endpoint: " + cscEndpoint);
            String tsaUrl = props.getProperty("TSA_URL");
            logger.info("TSA URL: " + tsaUrl);
            if (this.outputDirPath == null || this.outputDirPath.equals("")) {
                if (!this.override) {
                    logger.info("'-output_directory' parameter is not set. The output signed file will replace the original file. Do you still want to continue [y/n]? ");
                    System.out.print("Warn: '-output_directory' parameter is not set. The output signed file will replace the original file. Do you still want to continue [y/n]? ");
                    Scanner sc = new Scanner(System.in);
                    String yesOrNo = sc.nextLine();
                    logger.info("User selected: " + yesOrNo);
                    if (yesOrNo.equalsIgnoreCase("n")) {
                        return;
                    }
                    if (!yesOrNo.equalsIgnoreCase("y")) {
                        System.out.print("Error: Possible value is y/n");
                        return;
                    }
                }
            } else {
                File outputDir = new File(this.outputDirPath);
                if (!outputDir.isDirectory()) {
                    logger.info("Not a valid output directory: " + this.outputDirPath);
                    System.out.print("Error: Not a valid output directory - " + this.outputDirPath);
                    return;
                }
                logger.info("Output directory path: " + outputDir);
            }
            String ext = FilenameUtils.getExtension((String)this.inputFilePath);
            File inputFile = new File(this.inputFilePath);
            if (!inputFile.exists()) {
                logger.info("Invalid input file path: " + inputFile);
                System.out.print("Error: Invalid input file path - " + inputFile);
                return;
            }
            logger.info("Input file path: " + this.inputFilePath);
            logger.info("File type: " + ext);
            String codeFormatType = this.getCodeFormatType(ext);
            logger.info("Code format type: " + codeFormatType);
            if (codeFormatType == null) {
                logger.info("Unsupported file format for signing: " + ext);
                System.out.print("Error: Unsupported file format for signing - " + ext);
                return;
            }
            AccessToken accessTokenObj = new AccessToken(clientId, this.username, this.password, oauth2Endpoint);
            String accessToken = accessTokenObj.getAccessToken();
            CscApi cscApi = new CscApi(accessToken, cscEndpoint);
            String[] evcsCredentialIds = null;
            String[] ovcsCredentialIds = null;
            String[] credentialIds = null;
            if (this.credentialId != null && !this.credentialId.equals("")) {
                logger.info("Credential ID in input parameter: " + this.credentialId);
                credentialIds = new String[]{this.credentialId};
            } else {
                logger.info("No credential ID provided in input parameter");
                evcsCredentialIds = cscApi.getCredentialIDs("EVCS");
                ovcsCredentialIds = cscApi.getCredentialIDs("OVCS");
                credentialIds = (String[])Stream.concat(Arrays.stream(evcsCredentialIds), Arrays.stream(ovcsCredentialIds)).toArray(String[]::new);
            }
            if (credentialIds.length == 0) {
                logger.info("No credential ID found for this user");
                System.out.print("Error: No credential ID found for this user");
                return;
            }
            if (credentialIds.length == 1) {
                Scanner otpInput;
                this.credentialId = credentialIds[0];
                logger.info("Credential ID retrieved from signatures service: " + this.credentialId);
                certs = cscApi.getCredentialInfo(credentialIds[0]);
                logger.info("Subject DN: " + certs.get(0).getSubjectDN());
                logger.info("Issuer DN: " + certs.get(0).getIssuerDN());
                logger.info("Certificate expiry: " + certs.get(0).getNotAfter());
                byte[] toBeSignedHash = this.getCodeHash(this.inputFilePath, codeFormatType);
                boolean scanSettings = cscApi.getScanSettingsResponse(this.credentialId);
                if (scanSettings || this.malwareBlock) {
                    File file2 = new File(this.inputFilePath);
                    byte[] fileContent = Files.readAllBytes(file2.toPath());
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    md.update(fileContent);
                    String hashToScan = Base64.getEncoder().encodeToString(md.digest());
                    boolean malwareDetected = cscApi.getMalwareScanResponse(this.credentialId, hashToScan, Base64.getEncoder().encodeToString(toBeSignedHash));
                    logger.info("malware detected: " + malwareDetected);
                    if (malwareDetected) {
                        System.out.println("code object is a malware. This code object cannot be signed using eSigner");
                        return;
                    }
                }
                String otp = null;
                boolean isOtpTypeOnline = cscApi.isOtpTypeOnline(this.credentialId);
                if (isOtpTypeOnline) {
                    cscApi.sendOtp(this.credentialId);
                    System.out.println("OTP sent on your registered mobile number");
                    System.out.print("Enter the OTP - Press enter to continue: ");
                    otpInput = new Scanner(System.in);
                    otp = otpInput.nextLine();
                    if (otp == null || otp.equals("")) {
                        System.out.print("Error: OTP not provided");
                        return;
                    }
                } else if (this.totpSecret == null || this.totpSecret.equals("")) {
                    System.out.print("Enter the OTP - Press enter to continue: ");
                    otpInput = new Scanner(System.in);
                    otp = otpInput.nextLine();
                    if (otp == null || otp.equals("")) {
                        System.out.print("Error: OTP not provided");
                        return;
                    }
                } else {
                    byte[] totpSeed = Base64.getDecoder().decode(this.totpSecret);
                    String hexKey = Hex.encodeHexString((byte[])totpSeed);
                    otp = TOTP.getOTP((String)hexKey);
                }
                String[] hashes = new String[]{Base64.getEncoder().encodeToString(toBeSignedHash)};
                String sad = cscApi.getCredentialsAuthorize(this.credentialId, 1, hashes, otp);
                signature = cscApi.signHash(this.credentialId, sad, hashes, "1.2.840.113549.1.1.11", this.malwareBlock)[0];
                logger.info("Signature value: " + signature);
                file = null;
                if (this.outputDirPath != null) {
                    File srcFile = new File(this.inputFilePath);
                    File targetFilePath = null;
                    targetFilePath = this.outputDirPath.substring(0, this.outputDirPath.length()).equals(File.separator) ? new File(this.outputDirPath + srcFile.getName()) : new File(this.outputDirPath + File.separator + srcFile.getName());
                    FileUtils.copyFile((File)srcFile, (File)targetFilePath);
                    file = targetFilePath;
                } else {
                    file = new File(this.inputFilePath);
                }
            } else {
                System.out.println("Multiple valid credential IDs are available for this user. Please use the '-credential_id' option to designate which certificate to use for signing. Please use the 'credential_info' command to obtain more details about each credential ID");
                if (evcsCredentialIds.length != 0) {
                    System.out.println("EVCS Credential ID(s): ");
                    for (String credId : evcsCredentialIds) {
                        logger.info("Credential ID: " + credId);
                        System.out.println("- " + credId);
                    }
                }
                if (ovcsCredentialIds.length != 0) {
                    System.out.println("OVCS Credential ID(s): ");
                    for (String credId : ovcsCredentialIds) {
                        logger.info("Credential ID: " + credId);
                        System.out.println("- " + credId);
                    }
                }
                return;
            }
            this.sign(file, codeFormatType, signature, certs, tsaUrl, this.inputFilePath);
            System.out.println("Code signed successfully: " + file.getAbsolutePath());
        }
        catch (AccessTokenException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (CscApiException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("", (Throwable)ex);
        }
    }

    private String getCodeFormatType(String fileExtension) {
        if (fileExtension.equals("acm") || fileExtension.equals("ax") || fileExtension.equals("cpl") || fileExtension.equals("dll") || fileExtension.equals("drv") || fileExtension.equals("efi") || fileExtension.equals("exe") || fileExtension.equals("mui") || fileExtension.equals("ocx") || fileExtension.equals("scr") || fileExtension.equals("sys") || fileExtension.equals("tsp") || fileExtension.equals("bin")) {
            return "pe";
        }
        if (fileExtension.equals("msi")) {
            return "msi";
        }
        if (fileExtension.equals("ps1")) {
            return "ps1";
        }
        if (fileExtension.equals("ps1xml")) {
            return "ps1xml";
        }
        if (fileExtension.equals("js")) {
            return "js";
        }
        if (fileExtension.equals("vbs")) {
            return "vbs";
        }
        if (fileExtension.equals("wsf")) {
            return "wsf";
        }
        if (fileExtension.equals("jar")) {
            return "jar";
        }
        if (fileExtension.equals("cat")) {
            return "cat";
        }
        if (fileExtension.equals("cab")) {
            return "cab";
        }
        if (fileExtension.equals("ova")) {
            return "ova";
        }
        if (fileExtension.equals("ovf")) {
            return "ovf";
        }
        return null;
    }

    private byte[] getCodeHash(String inputFilePath, String codeFormatType) throws Exception {
        Object file;
        if (codeFormatType.equals("jar")) {
            JarSignature jarSignature = new JarSignature();
            return jarSignature.getHash(inputFilePath);
        }
        if (codeFormatType.equals("cat")) {
            CatSignature catSignature = new CatSignature();
            return catSignature.getHash(inputFilePath, this.programName);
        }
        if (codeFormatType.equals("ova")) {
            OvaSignature ovaSignature = new OvaSignature(inputFilePath, codeFormatType);
            return ovaSignature.getHash();
        }
        if (codeFormatType.equals("ovf")) {
            OvaSignature ovaSignature = new OvaSignature(inputFilePath, codeFormatType);
            return ovaSignature.getHash();
        }
        ASN1Object contentDigestASN1 = null;
        File srcFile = new File(inputFilePath);
        if (codeFormatType.equals("pe")) {
            file = new PEFile(srcFile);
            file.pad(8);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("msi")) {
            file = new MSIFile(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("ps1")) {
            file = new PowerShellScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("ps1xml")) {
            file = new PowerShellXMLScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("js")) {
            file = new JScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("vbs")) {
            file = new VBScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("wsf")) {
            file = new WindowsScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("cab")) {
            file = new MSCabinetFile(srcFile);
            contentDigestASN1 = ((MSCabinetFile)file).createIndirectData(DigestAlgorithm.SHA256);
        }
        byte[] toBeSignedHash = CodeSignature.getHash(contentDigestASN1, this.programName);
        return toBeSignedHash;
    }

    private void sign(File codeFilePath, String codeFormatType, String signature, List<X509Certificate> certsList, String tsaUrl, String inputFilePath) throws Exception {
        if (codeFormatType.equals("pe")) {
            PEFile file = new PEFile(codeFilePath);
            file.pad(8);
            file.setSignature(CodeSignature.generateSignedData(file.createIndirectData(DigestAlgorithm.SHA256), signature, certsList, tsaUrl, this.programName));
            file.save();
        } else if (codeFormatType.equals("msi")) {
            MSIFile file = new MSIFile(codeFilePath);
            file.setSignature(CodeSignature.generateSignedData(file.createIndirectData(DigestAlgorithm.SHA256), signature, certsList, tsaUrl, this.programName));
            file.save();
        } else if (codeFormatType.equals("ps1")) {
            PowerShellScript file = new PowerShellScript(codeFilePath);
            file.setSignature(CodeSignature.generateSignedData(file.createIndirectData(DigestAlgorithm.SHA256), signature, certsList, tsaUrl, this.programName));
            file.save();
        } else if (codeFormatType.equals("ps1xml")) {
            PowerShellXMLScript file = new PowerShellXMLScript(codeFilePath);
            file.setSignature(CodeSignature.generateSignedData(file.createIndirectData(DigestAlgorithm.SHA256), signature, certsList, tsaUrl, this.programName));
            file.save();
        } else if (codeFormatType.equals("js")) {
            JScript file = new JScript(codeFilePath);
            file.setSignature(CodeSignature.generateSignedData(file.createIndirectData(DigestAlgorithm.SHA256), signature, certsList, tsaUrl, this.programName));
            file.save();
        } else if (codeFormatType.equals("vbs")) {
            VBScript file = new VBScript(codeFilePath);
            file.setSignature(CodeSignature.generateSignedData(file.createIndirectData(DigestAlgorithm.SHA256), signature, certsList, tsaUrl, this.programName));
            file.save();
        } else if (codeFormatType.equals("wsf")) {
            WindowsScript file = new WindowsScript(codeFilePath);
            file.setSignature(CodeSignature.generateSignedData(file.createIndirectData(DigestAlgorithm.SHA256), signature, certsList, tsaUrl, this.programName));
            file.save();
        } else if (codeFormatType.equals("cab")) {
            MSCabinetFile file = new MSCabinetFile(codeFilePath);
            file.setSignature(CodeSignature.generateSignedData(file.createIndirectData(DigestAlgorithm.SHA256), signature, certsList, tsaUrl, this.programName));
            file.save();
        } else if (codeFormatType.equals("jar")) {
            X509Certificate[] certs = new X509Certificate[certsList.size()];
            JarSignature jarSignature = new JarSignature();
            byte[] signedJar = jarSignature.sign(signature, codeFilePath.getPath(), tsaUrl, certsList.toArray(certs));
            FileOutputStream fout = new FileOutputStream(codeFilePath);
            fout.write(signedJar);
            fout.close();
        } else if (codeFormatType.equals("cat")) {
            CatSignature catSignature = new CatSignature();
            byte[] signedCat = catSignature.sign(signature, codeFilePath, tsaUrl, certsList, this.programName);
            FileOutputStream fout = new FileOutputStream(codeFilePath);
            fout.write(signedCat);
            fout.close();
        } else if (codeFormatType.equals("ova")) {
            OvaSignature ovaSignature = new OvaSignature(inputFilePath, codeFormatType);
            byte[] signedOva = ovaSignature.sign(signature, certsList);
            FileOutputStream fout = new FileOutputStream(codeFilePath);
            fout.write(signedOva);
            fout.close();
        } else if (codeFormatType.equals("ovf")) {
            OvaSignature ovaSignature = new OvaSignature(codeFilePath.getPath(), codeFormatType);
            ovaSignature.copyFiles(inputFilePath);
            codeFilePath = new File(FilenameUtils.removeExtension((String)codeFilePath.getPath()) + ".cert");
            byte[] signedOva = ovaSignature.sign(signature, certsList);
            FileOutputStream fout = new FileOutputStream(codeFilePath);
            fout.write(signedOva);
            fout.close();
        }
    }

    static {
        try {
            FileInputStream inputStream = new FileInputStream(Paths.getLog4j2Path());
            ConfigurationSource source = new ConfigurationSource((InputStream)inputStream);
            Configurator.initialize(null, (ConfigurationSource)source);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger = LogManager.getLogger(SignCommand.class);
    }
}

