/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.code.signing.tool.commands;

import com.ssl.code.signing.tool.code.CatSignature;
import com.ssl.code.signing.tool.code.CodeSignature;
import com.ssl.code.signing.tool.code.JarSignature;
import com.ssl.code.signing.tool.code.OvaSignature;
import com.ssl.code.signing.tool.file.OvfFile;
import com.ssl.code.signing.tool.mscab.MSCabinetFile;
import com.ssl.code.signing.tool.util.Paths;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Base64;
import net.jsign.DigestAlgorithm;
import net.jsign.msi.MSIFile;
import net.jsign.pe.PEFile;
import net.jsign.script.JScript;
import net.jsign.script.PowerShellScript;
import net.jsign.script.PowerShellXMLScript;
import net.jsign.script.VBScript;
import net.jsign.script.WindowsScript;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.bouncycastle.asn1.ASN1Object;
import picocli.CommandLine;

@CommandLine.Command(name="hash", description={"Pre-compute hash(es) to sign"}, version={"v1.2.7"}, mixinStandardHelpOptions=true)
public class HashCommand
implements Runnable {
    private static final Logger logger;
    @CommandLine.Option(names={"-input_dir_path"}, description={"Input directory path where to pick file for hash computation"}, required=true)
    private String inputDirPath;
    @CommandLine.Option(names={"-program_name"}, description={"Program name"}, required=false)
    private String programName;

    @Override
    public void run() {
        try {
            File[] listFiles;
            logger.info("Command: compute hash(es)");
            File inputDir = new File(this.inputDirPath);
            if (!inputDir.exists()) {
                logger.info("Not a valid input directory: " + inputDir);
                System.out.print("Error: Not a valid input directory - " + inputDir);
                return;
            }
            if (!this.checkValidOutputDir(inputDir)) {
                return;
            }
            logger.info("Input directory path: " + this.inputDirPath);
            for (File file : listFiles = inputDir.listFiles(OvfFile.ignoreFiles())) {
                String fileExtension = FilenameUtils.getExtension((String)file.getName());
                logger.info("File extension: " + fileExtension);
                String codeFormatType = this.getCodeFormatType(fileExtension);
                logger.info("Code format type: " + codeFormatType);
                byte[] hash = this.getCodeHash(file.getAbsolutePath(), codeFormatType, this.programName);
                FileOutputStream fout = new FileOutputStream(inputDir + File.separator + file.getName() + ".hash");
                fout.write(Base64.getEncoder().encode(hash));
                fout.close();
            }
            if (this.programName != null) {
                logger.info("Program name: " + this.programName);
                FileOutputStream fout = new FileOutputStream(inputDir + File.separator + "program_name.txt");
                fout.write(this.programName.getBytes());
                fout.close();
            }
            System.out.println("Hash command executed successfully. Hash files created at: " + this.inputDirPath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("", (Throwable)ex);
        }
    }

    private boolean checkValidOutputDir(File inputDirPath) throws Exception {
        File[] listFiles;
        for (File file : listFiles = inputDirPath.listFiles(OvfFile.ignoreFiles())) {
            String fileExtension;
            if (file.isDirectory()) {
                logger.info("Directory must not be present: " + file.getName());
                System.out.print("Error: Directory must not be present: " + file.getName());
                return false;
            }
            if (!file.isFile() || (fileExtension = FilenameUtils.getExtension((String)file.getName())).equals("acm") || fileExtension.equals("ax") || fileExtension.equals("cpl") || fileExtension.equals("dll") || fileExtension.equals("drv") || fileExtension.equals("efi") || fileExtension.equals("exe") || fileExtension.equals("mui") || fileExtension.equals("ocx") || fileExtension.equals("scr") || fileExtension.equals("sys") || fileExtension.equals("tsp") || fileExtension.equals("bin") || fileExtension.equals("msi") || fileExtension.equals("ps1") || fileExtension.equals("ps1xml") || fileExtension.equals("js") || fileExtension.equals("vbs") || fileExtension.equals("wsf") || fileExtension.equals("jar") || fileExtension.equals("cat") || fileExtension.equals("cab") || fileExtension.equals("ova") || fileExtension.equals("ovf")) continue;
            logger.info("Error: File extension not allowed: " + file.getName());
            System.out.print("Error: File extension not allowed: " + file.getName());
            return false;
        }
        if (listFiles.length > 100) {
            logger.info("max 100 files are allowed. Current file count is: " + listFiles.length);
            System.out.print("max 100 files are allowed. Current file count is: " + listFiles.length);
            return false;
        }
        return true;
    }

    private byte[] getCodeHash(String inputFilePath, String codeFormatType, String programName) throws Exception {
        Object file;
        if (codeFormatType.equals("jar")) {
            JarSignature jarSignature = new JarSignature();
            return jarSignature.getHash(inputFilePath);
        }
        if (codeFormatType.equals("cat")) {
            CatSignature catSignature = new CatSignature();
            return catSignature.getHash(inputFilePath, programName);
        }
        if (codeFormatType.equals("ova")) {
            OvaSignature ovaSignature = new OvaSignature(inputFilePath, codeFormatType);
            return ovaSignature.getHash();
        }
        if (codeFormatType.equals("ovf")) {
            OvaSignature ovaSignature = new OvaSignature(inputFilePath, codeFormatType);
            return ovaSignature.getHash();
        }
        ASN1Object contentDigestASN1 = null;
        File srcFile = new File(inputFilePath);
        if (codeFormatType.equals("pe")) {
            file = new PEFile(srcFile);
            file.pad(8);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("msi")) {
            file = new MSIFile(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("ps1")) {
            file = new PowerShellScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("ps1xml")) {
            file = new PowerShellXMLScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("js")) {
            file = new JScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("vbs")) {
            file = new VBScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("wsf")) {
            file = new WindowsScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("cab")) {
            file = new MSCabinetFile(srcFile);
            contentDigestASN1 = ((MSCabinetFile)file).createIndirectData(DigestAlgorithm.SHA256);
        }
        byte[] toBeSignedHash = CodeSignature.getHash(contentDigestASN1, programName);
        return toBeSignedHash;
    }

    private String getCodeFormatType(String fileExtension) {
        if (fileExtension.equals("acm") || fileExtension.equals("ax") || fileExtension.equals("cpl") || fileExtension.equals("dll") || fileExtension.equals("drv") || fileExtension.equals("efi") || fileExtension.equals("exe") || fileExtension.equals("mui") || fileExtension.equals("ocx") || fileExtension.equals("scr") || fileExtension.equals("sys") || fileExtension.equals("tsp") || fileExtension.equals("bin")) {
            return "pe";
        }
        if (fileExtension.equals("msi")) {
            return "msi";
        }
        if (fileExtension.equals("ps1")) {
            return "ps1";
        }
        if (fileExtension.equals("ps1xml")) {
            return "ps1xml";
        }
        if (fileExtension.equals("js")) {
            return "js";
        }
        if (fileExtension.equals("vbs")) {
            return "vbs";
        }
        if (fileExtension.equals("wsf")) {
            return "wsf";
        }
        if (fileExtension.equals("jar")) {
            return "jar";
        }
        if (fileExtension.equals("cat")) {
            return "cat";
        }
        if (fileExtension.equals("cab")) {
            return "cab";
        }
        if (fileExtension.equals("ova")) {
            return "ova";
        }
        if (fileExtension.equals("ovf")) {
            return "ovf";
        }
        return null;
    }

    static {
        try {
            FileInputStream inputStream = new FileInputStream(Paths.getLog4j2Path());
            ConfigurationSource source = new ConfigurationSource((InputStream)inputStream);
            Configurator.initialize(null, (ConfigurationSource)source);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger = LogManager.getLogger(HashCommand.class);
    }
}

