/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.code.signing.tool.commands;

import com.ssl.code.signing.tool.commands.CodeScanCommand;
import com.ssl.code.signing.tool.csc.CscApi;
import com.ssl.code.signing.tool.exception.AccessTokenException;
import com.ssl.code.signing.tool.exception.CscApiException;
import com.ssl.code.signing.tool.util.AccessToken;
import com.ssl.code.signing.tool.util.Paths;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import picocli.CommandLine;

@CommandLine.Command(name="get_scan_settings", description={"Command to check whether malware scanning is enabled for this user and signing credential"}, version={"v1.2.7"}, mixinStandardHelpOptions=true)
public class GetScanSettingsCommand
implements Runnable {
    private static final Logger logger;
    @CommandLine.Option(names={"-username"}, description={"RA username"}, required=true)
    private String username;
    @CommandLine.Option(names={"-password"}, description={"RA password"}, required=true)
    private String password;
    @CommandLine.Option(names={"-credential_id"}, description={"Credential ID against which code scanning is to be performed"}, required=true)
    private String credentialId;

    @Override
    public void run() {
        try {
            logger.info("Command: get_scan_settings");
            Properties props = new Properties();
            props.load(new FileInputStream(Paths.getConfigFilePath()));
            String clientId = props.getProperty("CLIENT_ID");
            logger.info("Client ID: " + clientId);
            String oauth2Endpoint = props.getProperty("OAUTH2_ENDPOINT");
            logger.info("OAuth2 URL: " + oauth2Endpoint);
            String cscEndpoint = props.getProperty("CSC_API_ENDPOINT");
            logger.info("CSC Endpoint: " + cscEndpoint);
            AccessToken accessTokenObj = new AccessToken(clientId, this.username, this.password, oauth2Endpoint);
            String accessToken = accessTokenObj.getAccessToken();
            CscApi cscApi = new CscApi(accessToken, cscEndpoint);
            boolean malwareScanEnabled = cscApi.getScanSettingsResponse(this.credentialId);
            System.out.println("malware scan settings enabled: " + malwareScanEnabled);
            logger.info("malware scan settings enabled: " + malwareScanEnabled);
        }
        catch (AccessTokenException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (CscApiException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("", (Throwable)ex);
        }
    }

    static {
        try {
            FileInputStream inputStream = new FileInputStream(Paths.getLog4j2Path());
            ConfigurationSource source = new ConfigurationSource((InputStream)inputStream);
            Configurator.initialize(null, (ConfigurationSource)source);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger = LogManager.getLogger(CodeScanCommand.class);
    }
}

