/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.code.signing.tool.commands;

import com.ssl.code.signing.tool.code.CatSignature;
import com.ssl.code.signing.tool.code.CodeSignature;
import com.ssl.code.signing.tool.code.JarSignature;
import com.ssl.code.signing.tool.csc.CscApi;
import com.ssl.code.signing.tool.exception.AccessTokenException;
import com.ssl.code.signing.tool.exception.CscApiException;
import com.ssl.code.signing.tool.mscab.MSCabinetFile;
import com.ssl.code.signing.tool.util.AccessToken;
import com.ssl.code.signing.tool.util.Paths;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Properties;
import net.jsign.DigestAlgorithm;
import net.jsign.msi.MSIFile;
import net.jsign.pe.PEFile;
import net.jsign.script.JScript;
import net.jsign.script.PowerShellScript;
import net.jsign.script.PowerShellXMLScript;
import net.jsign.script.VBScript;
import net.jsign.script.WindowsScript;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.bouncycastle.asn1.ASN1Object;
import picocli.CommandLine;

@CommandLine.Command(name="scan_code", description={"Scan code for malware"}, version={"v1.2.7"}, mixinStandardHelpOptions=true)
public class CodeScanCommand
implements Runnable {
    private static final Logger logger;
    @CommandLine.Option(names={"-username"}, description={"RA username"}, required=true)
    private String username;
    @CommandLine.Option(names={"-password"}, description={"RA password"}, required=true)
    private String password;
    @CommandLine.Option(names={"-input_file_path"}, description={"Path of the code object to scan for malware"}, required=true)
    private String inputFilePath;
    @CommandLine.Option(names={"-program_name"}, description={"Program name. The same name must be used when signing"}, required=false)
    private String programName;
    @CommandLine.Option(names={"-credential_id"}, description={"Credential ID against which code scanning is to be performed"}, required=true)
    private String credentialId;

    @Override
    public void run() {
        try {
            logger.info("Command: scan_code");
            Properties props = new Properties();
            props.load(new FileInputStream(Paths.getConfigFilePath()));
            String clientId = props.getProperty("CLIENT_ID");
            logger.info("Client ID: " + clientId);
            String oauth2Endpoint = props.getProperty("OAUTH2_ENDPOINT");
            logger.info("OAuth2 URL: " + oauth2Endpoint);
            String cscEndpoint = props.getProperty("CSC_API_ENDPOINT");
            logger.info("CSC Endpoint: " + cscEndpoint);
            String ext = FilenameUtils.getExtension((String)this.inputFilePath);
            File inputFile = new File(this.inputFilePath);
            if (!inputFile.exists()) {
                logger.info("Invalid input file path: " + inputFile);
                System.out.print("Error: Invalid input file path - " + inputFile);
                return;
            }
            logger.info("Input file path: " + this.inputFilePath);
            logger.info("File type: " + ext);
            String codeFormatType = this.getCodeFormatType(ext);
            logger.info("Code format type: " + codeFormatType);
            if (codeFormatType == null) {
                logger.info("Unsupported file format for signing: " + ext);
                System.out.print("Error: Unsupported file format for signing - " + ext);
                return;
            }
            String hashToSign = Base64.getEncoder().encodeToString(this.getCodeHash(this.inputFilePath, codeFormatType, this.programName));
            File file = new File(this.inputFilePath);
            byte[] fileContent = Files.readAllBytes(file.toPath());
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(fileContent);
            String hashToScan = Base64.getEncoder().encodeToString(md.digest());
            AccessToken accessTokenObj = new AccessToken(clientId, this.username, this.password, oauth2Endpoint);
            String accessToken = accessTokenObj.getAccessToken();
            CscApi cscApi = new CscApi(accessToken, cscEndpoint);
            boolean malwareDetected = cscApi.getMalwareScanResponse(this.credentialId, hashToScan, hashToSign);
            if (malwareDetected) {
                System.out.println("code object is a malware. This code object cannot be signed using eSigner");
            } else {
                System.out.println("code object is not a malware. You can proceed signing this code object");
            }
        }
        catch (AccessTokenException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (CscApiException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("", (Throwable)ex);
        }
    }

    private String getCodeFormatType(String fileExtension) {
        if (fileExtension.equals("acm") || fileExtension.equals("ax") || fileExtension.equals("cpl") || fileExtension.equals("dll") || fileExtension.equals("drv") || fileExtension.equals("efi") || fileExtension.equals("exe") || fileExtension.equals("mui") || fileExtension.equals("ocx") || fileExtension.equals("scr") || fileExtension.equals("sys") || fileExtension.equals("tsp") || fileExtension.equals("bin")) {
            return "pe";
        }
        if (fileExtension.equals("msi")) {
            return "msi";
        }
        if (fileExtension.equals("ps1")) {
            return "ps1";
        }
        if (fileExtension.equals("ps1xml")) {
            return "ps1xml";
        }
        if (fileExtension.equals("js")) {
            return "js";
        }
        if (fileExtension.equals("vbs")) {
            return "vbs";
        }
        if (fileExtension.equals("wsf")) {
            return "wsf";
        }
        if (fileExtension.equals("jar")) {
            return "jar";
        }
        if (fileExtension.equals("cat")) {
            return "cat";
        }
        if (fileExtension.equals("cab")) {
            return "cab";
        }
        return null;
    }

    private byte[] getCodeHash(String inputFilePath, String codeFormatType, String programName) throws Exception {
        Object file;
        if (codeFormatType.equals("jar")) {
            JarSignature jarSignature = new JarSignature();
            return jarSignature.getHash(inputFilePath);
        }
        if (codeFormatType.equals("cat")) {
            CatSignature catSignature = new CatSignature();
            return catSignature.getHash(inputFilePath, programName);
        }
        ASN1Object contentDigestASN1 = null;
        File srcFile = new File(inputFilePath);
        if (codeFormatType.equals("pe")) {
            file = new PEFile(srcFile);
            file.pad(8);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("msi")) {
            file = new MSIFile(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("ps1")) {
            file = new PowerShellScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("ps1xml")) {
            file = new PowerShellXMLScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("js")) {
            file = new JScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("vbs")) {
            file = new VBScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("wsf")) {
            file = new WindowsScript(srcFile);
            contentDigestASN1 = file.createIndirectData(DigestAlgorithm.SHA256);
        } else if (codeFormatType.equals("cab")) {
            file = new MSCabinetFile(srcFile);
            contentDigestASN1 = ((MSCabinetFile)file).createIndirectData(DigestAlgorithm.SHA256);
        }
        byte[] toBeSignedHash = CodeSignature.getHash(contentDigestASN1, programName);
        return toBeSignedHash;
    }

    static {
        try {
            FileInputStream inputStream = new FileInputStream(Paths.getLog4j2Path());
            ConfigurationSource source = new ConfigurationSource((InputStream)inputStream);
            Configurator.initialize(null, (ConfigurationSource)source);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger = LogManager.getLogger(CodeScanCommand.class);
    }
}

