/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.asn1.authenticode;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class AuthenticodeSignedData
extends ASN1Object {
    private AlgorithmIdentifier digestAlgorithm;
    private ContentInfo contentInfo;
    private ASN1Set certificates;
    private SignerInfo signerInformation;

    public AuthenticodeSignedData(AlgorithmIdentifier digestAlgorithm, ContentInfo contentInfo, ASN1Set certificates, SignerInfo signerInformation) {
        this.digestAlgorithm = digestAlgorithm;
        this.contentInfo = contentInfo;
        this.certificates = certificates;
        this.signerInformation = signerInformation;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(1L));
        v.add((ASN1Encodable)new DERSet((ASN1Encodable)this.digestAlgorithm));
        v.add((ASN1Encodable)this.contentInfo);
        if (this.certificates != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.certificates));
        }
        v.add((ASN1Encodable)new DERSet((ASN1Encodable)this.signerInformation));
        return new BERSequence(v);
    }
}

