/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.code.signing.tool.file;

import com.ssl.code.signing.tool.file.IOvfFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class OvaFile
implements IOvfFile {
    private final File file;
    private final String basename;
    private Map.Entry<TarArchiveEntry, byte[]> manifest;
    private Map.Entry<TarArchiveEntry, byte[]> ovf;
    private Map.Entry<TarArchiveEntry, byte[]> cert;
    private final Map<TarArchiveEntry, byte[]> otherResources = new HashMap<TarArchiveEntry, byte[]>();

    public OvaFile(String filename) throws IOException, NoSuchAlgorithmException {
        this.file = new File(filename);
        this.basename = FilenameUtils.getBaseName((String)filename);
        this.extractInfo();
    }

    public void extractInfo() throws IOException, NoSuchAlgorithmException {
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream((InputStream)new FileInputStream(this.file));){
            TarArchiveEntry tarArchiveEntry;
            while ((tarArchiveEntry = tarInput.getNextTarEntry()) != null) {
                String name = tarArchiveEntry.getName();
                tarArchiveEntry.setName(name);
                if (name.endsWith("mf")) {
                    byte[] manifestBytes = this.createManifest();
                    this.manifest = new AbstractMap.SimpleEntry<TarArchiveEntry, byte[]>(tarArchiveEntry, manifestBytes);
                    continue;
                }
                if (name.endsWith("ovf")) {
                    this.ovf = new AbstractMap.SimpleEntry<TarArchiveEntry, byte[]>(tarArchiveEntry, IOUtils.toByteArray((InputStream)tarInput));
                    continue;
                }
                if (name.endsWith("cert")) {
                    this.cert = new AbstractMap.SimpleEntry<TarArchiveEntry, byte[]>(tarArchiveEntry, IOUtils.toByteArray((InputStream)tarInput));
                    continue;
                }
                this.otherResources.put(tarArchiveEntry, IOUtils.toByteArray((InputStream)tarInput));
            }
        }
    }

    @Override
    public void save(OutputStream outputStream) throws IOException, NoSuchAlgorithmException {
        TarArchiveOutputStream tarArchive = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(outputStream));
        TarArchiveEntry ovfEntry = this.ovf.getKey();
        ovfEntry.setSize((long)this.ovf.getValue().length);
        tarArchive.putArchiveEntry((ArchiveEntry)ovfEntry);
        tarArchive.write(this.ovf.getValue());
        tarArchive.closeArchiveEntry();
        byte[] manifestBytes = this.createManifest();
        this.manifest.setValue(manifestBytes);
        TarArchiveEntry manifestEntry = this.manifest.getKey();
        manifestEntry.setSize((long)this.manifest.getValue().length);
        tarArchive.putArchiveEntry((ArchiveEntry)manifestEntry);
        tarArchive.write(this.manifest.getValue());
        tarArchive.closeArchiveEntry();
        if (this.cert != null) {
            TarArchiveEntry certEntry = this.cert.getKey();
            certEntry.setSize((long)this.cert.getValue().length);
            tarArchive.putArchiveEntry((ArchiveEntry)certEntry);
            tarArchive.write(this.cert.getValue());
            tarArchive.closeArchiveEntry();
        }
        for (Map.Entry<TarArchiveEntry, byte[]> entry : this.otherResources.entrySet()) {
            TarArchiveEntry tarArchiveEntry = entry.getKey();
            tarArchiveEntry.setSize((long)entry.getValue().length);
            tarArchive.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
            tarArchive.write(entry.getValue());
            tarArchive.closeArchiveEntry();
        }
        tarArchive.close();
    }

    private byte[] createManifest() throws NoSuchAlgorithmException {
        StringBuilder manifestFile = new StringBuilder();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        manifestFile.append(String.format("SHA256(%s)= %s", this.ovf.getKey().getName(), Hex.toHexString((byte[])messageDigest.digest(this.ovf.getValue()))));
        manifestFile.append(System.lineSeparator());
        for (Map.Entry<TarArchiveEntry, byte[]> tarArchiveEntryEntry : this.otherResources.entrySet()) {
            manifestFile.append(String.format("SHA256(%s)= %s", tarArchiveEntryEntry.getKey().getName(), Hex.toHexString((byte[])messageDigest.digest(tarArchiveEntryEntry.getValue()))));
            manifestFile.append(System.lineSeparator());
        }
        return manifestFile.toString().getBytes();
    }

    @Override
    public void createSignature(byte[] signature, X509Certificate certificate) throws CertificateEncodingException, IOException {
        String signedCertText = String.format("SHA256(%s.mf)= %s", this.basename, Hex.toHexString((byte[])signature)) + System.lineSeparator() + this.convertCertificateToPem(certificate.getEncoded());
        this.setCert(signedCertText.getBytes());
    }

    @Override
    public byte[] toBeSignedData() {
        return this.manifest.getValue();
    }

    private void setCert(byte[] cert) {
        if (this.cert == null) {
            TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(this.basename + ".cert");
            this.cert = new AbstractMap.SimpleEntry<TarArchiveEntry, byte[]>(tarArchiveEntry, new byte[0]);
        }
        this.cert.setValue(cert);
    }

    private String convertCertificateToPem(byte[] x509Cert) throws IOException {
        PemObject pemObject = new PemObject("CERTIFICATE", x509Cert);
        StringWriter sw = new StringWriter();
        try (PemWriter pw = new PemWriter((Writer)sw);){
            pw.writeObject((PemObjectGenerator)pemObject);
        }
        return sw.toString();
    }
}

