/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.code.signing.tool.csc;

import com.ssl.code.signing.tool.exception.CscApiException;
import com.ssl.code.signing.tool.http.HTTPClient;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class CscApi {
    private static final Logger logger = LogManager.getLogger(CscApi.class);
    private String accessToken;
    private String CscEndpoint;

    public CscApi(String accessToken, String CscEndpoint) {
        this.accessToken = accessToken;
        this.CscEndpoint = CscEndpoint;
    }

    public String[] getCredentialIDs(String certificateType) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONObject body = new JSONObject();
        body.put((Object)"clientData", (Object)certificateType);
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/csc/v0/credentials/list", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        JSONParser responseParser = new JSONParser();
        JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
        if (client.getHttpStatus() != 200) {
            JSONObject errorJson = (JSONObject)responseParser.parse(responseJson.toJSONString());
            if (errorJson.get((Object)"error_description") != null) {
                String errorDesc = (String)errorJson.get((Object)"error_description");
                if (errorDesc.contains("Signing credentials not configured. Make sure certificate is issued before signing")) {
                    return new String[0];
                }
                throw new CscApiException(responseJson.toJSONString());
            }
            throw new CscApiException(responseJson.toJSONString());
        }
        JSONArray credendialIdsArr = (JSONArray)responseJson.get((Object)"credentialIDs");
        Object[] credentialIds = new String[credendialIdsArr.size()];
        credendialIdsArr.toArray(credentialIds);
        return credentialIds;
    }

    public List<X509Certificate> getCredentialInfo(String credentialId) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONObject body = new JSONObject();
        body.put((Object)"credentialID", (Object)credentialId);
        body.put((Object)"certificates", (Object)"chain");
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/csc/v0/credentials/info", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        JSONParser responseParser = new JSONParser();
        JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
        if (client.getHttpStatus() != 200) {
            String errorDesc = (String)responseJson.get((Object)"error_description");
            throw new CscApiException(errorDesc);
        }
        JSONObject cert = (JSONObject)responseJson.get((Object)"cert");
        JSONArray certArr = (JSONArray)cert.get((Object)"certificates");
        ArrayList<X509Certificate> certsList = new ArrayList<X509Certificate>();
        for (String certificateBase64 : certArr) {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            byte[] decodedCert = Base64.getDecoder().decode(certificateBase64);
            X509Certificate certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(decodedCert));
            certsList.add(certificate);
        }
        return certsList;
    }

    public String getCredentialsAuthorize(String credentialId, int numOfSignatures, String[] hashes, String otp) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONArray hashesArr = new JSONArray();
        for (String hash : hashes) {
            hashesArr.add((Object)hash);
        }
        JSONObject body = new JSONObject();
        body.put((Object)"credentialID", (Object)credentialId);
        body.put((Object)"numSignatures", (Object)numOfSignatures);
        body.put((Object)"hash", (Object)hashesArr);
        body.put((Object)"OTP", (Object)otp);
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/csc/v0/credentials/authorize", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        JSONParser responseParser = new JSONParser();
        JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
        if (client.getHttpStatus() != 200) {
            String errorDesc = (String)responseJson.get((Object)"error_description");
            throw new CscApiException(errorDesc);
        }
        String sad = (String)responseJson.get((Object)"SAD");
        return sad;
    }

    public String[] signHash(String credentialId, String sad, String[] hashes, String sigAlgo, boolean malwareScan) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONArray hashesArr = new JSONArray();
        for (String hash : hashes) {
            hashesArr.add((Object)hash);
        }
        JSONObject body = new JSONObject();
        body.put((Object)"credentialID", (Object)credentialId);
        body.put((Object)"SAD", (Object)sad);
        body.put((Object)"hash", (Object)hashesArr);
        body.put((Object)"signAlgo", (Object)sigAlgo);
        if (malwareScan) {
            body.put((Object)"clientData", (Object)"MALWARE_SCAN");
        }
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/csc/v0/signatures/signHash", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        JSONParser responseParser = new JSONParser();
        String responseBody = new String(client.getBody());
        logger.info("sign hash response: " + responseBody);
        JSONObject responseJson = (JSONObject)responseParser.parse(responseBody);
        if (client.getHttpStatus() != 200) {
            String errorDesc = (String)responseJson.get((Object)"error_description");
            throw new CscApiException(errorDesc);
        }
        JSONArray signaturesArr = (JSONArray)responseJson.get((Object)"signatures");
        Object[] signatures = new String[signaturesArr.size()];
        signaturesArr.toArray(signatures);
        return signatures;
    }

    public boolean getMalwareScanResponse(String credentialId, String hashToScan, String hashToSign) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONObject body = new JSONObject();
        body.put((Object)"credential_id", (Object)credentialId);
        body.put((Object)"hash_to_scan", (Object)hashToScan);
        body.put((Object)"hash_to_sign", (Object)hashToSign);
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/scan/hash", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        JSONParser responseParser = new JSONParser();
        JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
        if (client.getHttpStatus() != 200) {
            throw new CscApiException(responseJson.toJSONString());
        }
        boolean malwareDetected = (Boolean)responseJson.get((Object)"malware_detected");
        return malwareDetected;
    }

    public boolean isOtpTypeOnline(String credentialId) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONObject body = new JSONObject();
        body.put((Object)"credentialID", (Object)credentialId);
        body.put((Object)"authInfo", (Object)true);
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/csc/v0/credentials/info", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        JSONParser responseParser = new JSONParser();
        JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
        if (client.getHttpStatus() != 200) {
            throw new CscApiException(responseJson.toJSONString());
        }
        String authMode = (String)responseJson.get((Object)"authMode");
        JSONObject otp = (JSONObject)responseJson.get((Object)"OTP");
        String otpType = (String)otp.get((Object)"type");
        return authMode.equals("explicit") && otpType.equals("online");
    }

    public void sendOtp(String credentialId) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONObject body = new JSONObject();
        body.put((Object)"credentialID", (Object)credentialId);
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/csc/v0/credentials/sendOTP", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        if (client.getHttpStatus() != 204) {
            JSONParser responseParser = new JSONParser();
            JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
            throw new CscApiException(responseJson.toJSONString());
        }
    }

    public boolean getScanSettingsResponse(String credentialId) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONObject body = new JSONObject();
        body.put((Object)"credential_id", (Object)credentialId);
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/scan/settings", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        JSONParser responseParser = new JSONParser();
        JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
        if (client.getHttpStatus() != 200) {
            throw new CscApiException(responseJson.toJSONString());
        }
        boolean malwareScanEnabled = (Boolean)responseJson.get((Object)"malware_scan_enabled");
        return malwareScanEnabled;
    }
}

